/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.networking;

import com.google.common.collect.HashBiMap;
import com.itayfeder.gelato_galore.reload.FlavorData;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SyncFlavorDataMessage {
    public static final Map<ResourceLocation, FlavorData> CLIENT_FLAVORS_MAP = HashBiMap.create();
    private static final Codec<Map<ResourceLocation, FlavorData>> CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, FlavorData.CODEC);
    private final Map<ResourceLocation, FlavorData> flavors;

    public SyncFlavorDataMessage(FriendlyByteBuf buf) {
        this.flavors = (Map)buf.m_271872_(CODEC);
    }

    public SyncFlavorDataMessage(Map<ResourceLocation, FlavorData> flavors) {
        this.flavors = flavors;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_272073_(CODEC, this.flavors);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            CLIENT_FLAVORS_MAP.clear();
            CLIENT_FLAVORS_MAP.putAll(this.flavors);
        });
        context.setPacketHandled(true);
        return true;
    }
}

